/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#ifndef _UDM_UTILS_H
#define _UDM_UTILS_H

/* for time_t */
#include <time.h>

/* for va_list */
#include <stdarg.h>

#include "udm_config.h"
#include "udm_common.h"

/* This is used in UdmTime_t2Str and in its callers */
#define UDM_MAXTIMESTRLEN	35


/* Some useful MACROs */
#define UDM_STRNCMP(x,y)	(strncmp(x,y,strlen(y)))
#define UDM_STRNCASECMP(x,y)	(strncasecmp(x,y,strlen(y)))
#define UDM_STREND(s)		(s+strlen(s))
#define UDM_FREE(x)		{if((x)!=NULL){free(x);x=NULL;}}
#define UDM_STRNCPY(x,y)	{strncpy(x,y,sizeof(x));x[sizeof(x)-1]=0;}
#define UDM_SKIP(s,set)		while((*s)&&(strchr(set,*s)))s++;
#define UDM_SKIPN(s,set)	while((*s)&&(!strchr(set,*s)))s++;

/* NULL safe atoi*/
#define UDM_ATOI(x)		((x)?atoi(x):0)
#define UDM_NULL2EMPTY(x)	((x)?(x):"")


/* Misc functions */
extern __INDLIB__ int		UdmInit(void);
extern char * UdmGetStrToken(char * s,char ** last);
extern char * UdmTrim(char * p, const char * delim);
extern char * UdmRTrim(char* p, const char * delim);
extern char * UdmHtmlSpecialChars(const char *str);
extern char * UdmUnescapeCGIQuery(char *d,char *s);
extern char * UdmEscapeURL(char *d,const char *s);
extern char * UdmRemove2Dot(char *path);
extern char * UdmBuildParamStr(char * dst,size_t len,const char * src,char ** argv,size_t argc);
extern char * UdmStrRemoveChars(char * str, const char * sep);
extern char * UdmStrRemoveDoubleChars(char * str, const char * sep);

/* This should convert Last-Modified time returned by webserver
 * to time_t (seconds since the Epoch). -kir
 */
extern time_t UdmHttpDate2Time_t(const char * date);

extern time_t UdmFTPDate2Time_t(char *date);

/***********************************************************
 * converts time_str to time_t (seconds)
 * time_str can be exactly number of seconds
 * or in the form 'xxxA[yyyB[zzzC]]'
 * (Spaces are allowed between xxx and A and yyy and so on)
 *   there xxx, yyy, zzz are numbers (can be negative!)
 *         A, B, C can be one of the following:
 *		s - second
 *		M - minute	
 *		h - hour
 *		d - day
 *		m - month
 *		y - year
 *	(these letters are as in strptime/strftime functions)
 *
 * Examples:
 * 1234 - 1234 seconds
 * 4h30M - 4 hours and 30 minutes (will return 9000 seconds)
 * 1y6m-15d - 1 year and six month minus 15 days (will return 45792000 s)
 * 1h-60M+1s - 1 hour minus 60 minutes plus 1 second (will return 1 s)
 */
time_t Udm_dp2time_t(char * time_str);


/* This one for printing HTTP Last-Modified: header */
extern void UdmTime_t2HttpStr(time_t t, char * time_str);
/* This one deals with timezone offset */
extern int UdmInitTZ(void);
extern unsigned long UdmStartTimer(void);


/* Probably string missing functions */

#ifndef HAVE_BZERO
extern void bzero(void *b, size_t len);
#endif

#ifndef HAVE_STRCASECMP
extern int strcasecmp(const char *s1, const char *s2);
#endif

#ifndef HAVE_STRNCASECMP
extern int strncasecmp(const char *s1, const char *s2, size_t n);
#endif

#ifndef HAVE_VSNPRINTF
extern int vsnprintf(char *str, size_t size, const char  *fmt,  va_list ap);
#endif

#ifndef HAVE_SNPRINTF
extern int snprintf(char *str, size_t size, const char *fmt, ...);
#endif

#ifndef HAVE_STRTOK_R
extern char *strtok_r(char *s, const char *delim, char **save_ptr);
#endif

#ifndef HAVE_STRNDUP
extern char *strndup(const char *str, size_t len);
#endif

extern int UdmStrMatch(const char *str, const char *strexp);
extern int UdmStrCaseMatch(const char *str, const char *strexp);
extern int UdmHex2Int(int h);


#define BASE64_LEN(len) (4 * (((len) + 2) / 3) +2)
extern __INDLIB__ void udm_base64_encode (const char *s, char *store, size_t length);
extern __INDLIB__ size_t udm_base64_decode (char * dst, const char * src, size_t len);
extern char * udm_rfc1522_decode(char * dst, const char *src);

/* Build directory */
extern int   UdmBuild(char * path, int mode);

/* SetEnv */
extern int UdmSetEnv(const char * name,const char * value);
extern void UdmUnsetEnv(const char * name);

extern void UdmUniRemoveDoubleSpaces(int * ustr);
extern void UdmUniPrint(int * ustr);

extern ssize_t UdmRecvall(int s, void *buf, size_t len);
extern ssize_t UdmSend(int s, const void *msg, size_t len, int flags);

extern void (*UdmSignal(int signo, void (*handler)(int)))(int);

#endif /* _UDM_UTILS_H */
